/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.caret.service.ctssh.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;

import gov.va.caret.service.ctssh.request.ChainedRequest;
import gov.va.caret.service.ctssh.request.Request;
import gov.va.caret.service.ctssh.request.SimpleRequest;
import gov.va.caret.service.ctssh.response.ChainedResponse;
import gov.va.caret.service.ctssh.response.Response;
import gov.va.caret.service.ctssh.response.SimpleResponse;
import gov.va.caret.service.ctssh.template.ParameterValidationResult;
import gov.va.caret.service.ctssh.template.SimpleTemplateRequestParameter;
import gov.va.caret.service.ctssh.template.TemplateHandler;
import gov.va.caret.service.ctssh.template.TemplateHttpHeader;
import gov.va.caret.service.ctssh.util.AppHelper;
import java.net.URL;



/**
 *
 * @author ronaday
 */
public class Executor {
    
    
    /**
     * @return
     */
    public static Executor newInstance()
    {
        return new Executor();
    }
    
    /**
     * 
     */
    private Executor()
    {
        
    }

    
	/**
	 * @param result_file_path
	 * @param _req
	 * @return
	 * @throws Exception
	 */
	public Response testResult(String result_file_path, Request _req) throws Exception {
    	//this is just for quick and dirty debugging
	SimpleResponse _response = new SimpleResponse((SimpleRequest)_req);
    	String return_data = AppHelper.loadFile(result_file_path);
        _response.HTTP_RESP_CODE = 666; 
        _response.HTTP_CONTENT_LENGTH = return_data.length();
        _response.HTTP_CONTENT_TYPE = "text";
        _response.HTTP_RESPONSE_MESSAGE = "mock execution";
        _response.processResult(return_data.toString());
    	return _response;
	
	}
    
    
    
    /**
     * @param _req
     * @return
     * @throws Exception
     */
    public Response execute(Request _req) throws Exception
    {
        Response _response = null;

        if(_req.type().intern() == "simple")
        {
        	
            SimpleRequest req = (SimpleRequest)_req;
            _response = new SimpleResponse(req);
        	
            AppHelper.log("EXECUTING " + req.key());
            ParameterValidationResult vresult = req.validate();
            _response.setValidationResult(vresult);
            
            if(vresult.valid())
            {
            	try{
            	
                    String request_xml = buildSoapRequest(req);

                     //DEBUG
                     AppHelper.log("\n------------------------\nREQUEST TO SEND\n----------------------------------\n" + AppHelper.getPrettyPrintXML(request_xml) + "\n-----------------------------\n");
                     //DEBUG

                    //create a connection to the remote server
                    //this is where things get a little wonky
                    //because of the way WebLogic works - if it's https we have to use the WebLogic HttpsURLConnection class
                    //and since that's not castable - all work has to be done directly on the object itself
                     
                    if(req.template().url().toLowerCase().startsWith("https:"))
                    {
                        //test to which environment we are in.  If we are in anything but local, then use the WebLogic HttpsURLConnection.  
                        //Otherwise use the javax.net.HttpsURLConnection
                        
                        if(TemplateHandler.instance().env().equals(TemplateHandler.ENV_LOCAL))
                        {
                            //this is local
                            AppHelper.log("CREATING SECURE STANDARD CONNECTION TO : " + req.template().url());                        
                            
                            javax.net.ssl.HttpsURLConnection mvicon = (javax.net.ssl.HttpsURLConnection) new URL(req.template().url()).openConnection();
                            mvicon.setDoOutput(true);
                            mvicon.setRequestMethod("POST");

                            //set all the headers required for this call
                            for(TemplateHttpHeader hdr: req.template().http_headers())
                            {
                                mvicon.setRequestProperty(hdr.key(), hdr.value());
                            }

                            //set the content length
                            //testing without this  ....   mvicon.setRequestProperty("Content-Length", String.valueOf(request_xml.getBytes().length));

                            //write out the request
                            BufferedWriter data_out = new BufferedWriter(new OutputStreamWriter(new DataOutputStream(mvicon.getOutputStream()), "UTF-8"));
                            data_out.write("\r\n");
                            data_out.write(request_xml);
                            data_out.write("\r\n");
                            data_out.flush();
                            data_out.close();

                            
                            
                            //read in the respons

                            String data_line;
                            StringBuilder return_data = new StringBuilder();

                            BufferedReader data_in;
                            if (mvicon.getResponseCode() == 500)//did we get an error? if so, set the reader to the error stream
                                data_in = new BufferedReader(new InputStreamReader(new DataInputStream(mvicon.getErrorStream()), "UTF-8"));
                            else //no error?  Then set the reader to the standard stream
                                data_in = new BufferedReader(new InputStreamReader(new DataInputStream(mvicon.getInputStream()), "UTF-8"));

                            //read all the data from the stream
                            while ((data_line = data_in.readLine()) != null) {
                                    return_data.append(data_line);
                            }

                            data_in.close();

                            ((SimpleResponse)_response).HTTP_RESP_CODE = mvicon.getResponseCode(); 
                            ((SimpleResponse)_response).HTTP_CONTENT_LENGTH = mvicon.getContentLength();
                            ((SimpleResponse)_response).HTTP_CONTENT_TYPE = mvicon.getContentType();
                            ((SimpleResponse)_response).HTTP_RESPONSE_MESSAGE = mvicon.getResponseMessage();
                            mvicon.disconnect();



                            ((SimpleResponse)_response).processResult(return_data.toString());                            
                            
                            
                            
                            
                        }else
                        {
                            //this is weblogic
                            AppHelper.log("CREATING SECURE WEBLOGIC CONNECTION TO : " + req.template().url());                        
                           // HttpURLConnection mvicon = (HttpURLConnection)new URL(req.template().url()).openConnection();
                            weblogic.net.http.HttpsURLConnection mvicon = (weblogic.net.http.HttpsURLConnection) new URL(req.template().url()).openConnection();
                            mvicon.setDoOutput(true);
                            mvicon.setRequestMethod("POST");

                            //set all the headers required for this call
                            for(TemplateHttpHeader hdr: req.template().http_headers())
                            {
                                mvicon.setRequestProperty(hdr.key(), hdr.value());
                            }

                            //set the content length
                            //testing without this mvicon.setRequestProperty("Content-Length", String.valueOf(request_xml.getBytes().length));

                            //write out the request
                            BufferedWriter data_out = new BufferedWriter(new OutputStreamWriter(new DataOutputStream(mvicon.getOutputStream()), "UTF-8"));
                            data_out.write("\r\n");
                            data_out.write(request_xml);
                            data_out.write("\r\n");
                            data_out.flush();
                            data_out.close();

                            //read in the respons

                            String data_line;
                            StringBuilder return_data = new StringBuilder();

                            BufferedReader data_in;
                            if (mvicon.getResponseCode() == 500)//did we get an error? if so, set the reader to the error stream
                                data_in = new BufferedReader(new InputStreamReader(new DataInputStream(mvicon.getErrorStream()), "UTF-8"));
                            else //no error?  Then set the reader to the standard stream
                                data_in = new BufferedReader(new InputStreamReader(new DataInputStream(mvicon.getInputStream()), "UTF-8"));

                            //read all the data from the stream
                            while ((data_line = data_in.readLine()) != null) {
                                    return_data.append(data_line);
                            }

                            data_in.close();

                            ((SimpleResponse)_response).HTTP_RESP_CODE = mvicon.getResponseCode(); 
                            ((SimpleResponse)_response).HTTP_CONTENT_LENGTH = mvicon.getContentLength();
                            ((SimpleResponse)_response).HTTP_CONTENT_TYPE = mvicon.getContentType();
                            ((SimpleResponse)_response).HTTP_RESPONSE_MESSAGE = mvicon.getResponseMessage();
                            mvicon.disconnect();



                            ((SimpleResponse)_response).processResult(return_data.toString());                            
                            
                        }
                        
                        
                        
                    }else
                    {
                        //standard connection used here
                        
                        AppHelper.log("CREATING CONNECTION TO : " + req.template().url());                        
                        HttpURLConnection mvicon = (HttpURLConnection)new URL(req.template().url()).openConnection();
                        
                        mvicon.setDoOutput(true);
                        mvicon.setRequestMethod("POST");

	                //set all the headers required for this call
	                for(TemplateHttpHeader hdr: req.template().http_headers())
	                {
	                    mvicon.setRequestProperty(hdr.key(), hdr.value());
	                }
	
	                //set the content length
	                //mvicon.setRequestProperty("Content-Length", String.valueOf(request_xml.getBytes().length));
	
	                //write out the request
	                BufferedWriter data_out = new BufferedWriter(new OutputStreamWriter(new DataOutputStream(mvicon.getOutputStream()), "UTF-8"));
	                data_out.write("\r\n");
	                data_out.write(request_xml);
	                data_out.write("\r\n");
	                data_out.flush();
	                data_out.close();
	
	                //read in the respons
	
	                String data_line;
	                StringBuilder return_data = new StringBuilder();
	
	                BufferedReader data_in;
	                if (mvicon.getResponseCode() == 500)//did we get an error? if so, set the reader to the error stream
	                    data_in = new BufferedReader(new InputStreamReader(new DataInputStream(mvicon.getErrorStream()), "UTF-8"));
	                else //no error?  Then set the reader to the standard stream
	                    data_in = new BufferedReader(new InputStreamReader(new DataInputStream(mvicon.getInputStream()), "UTF-8"));
	
	                //read all the data from the stream
	                while ((data_line = data_in.readLine()) != null) {
	                        return_data.append(data_line);
	                }
	
	                data_in.close();

	                ((SimpleResponse)_response).HTTP_RESP_CODE = mvicon.getResponseCode(); 
	                ((SimpleResponse)_response).HTTP_CONTENT_LENGTH = mvicon.getContentLength();
	                ((SimpleResponse)_response).HTTP_CONTENT_TYPE = mvicon.getContentType();
	                ((SimpleResponse)_response).HTTP_RESPONSE_MESSAGE = mvicon.getResponseMessage();
	                mvicon.disconnect();
	                


	                ((SimpleResponse)_response).processResult(return_data.toString());
                        
                    }
                    
                     
                    
	                
	                
            	}catch(Exception e)
            	{
            		 AppHelper.log("ERROR : " + e.getMessage());
            		 e.printStackTrace();
            		_response.setError(e);
            		_response.setErrorMessage(req.template().failmsg() + "\nRETURNED MESSAGE : " + e.getMessage());
            	}
            	
            }

          
            
            
        }else
        {
            //this is a chained call
            ChainedRequest req = (ChainedRequest)_req;
            _response = new ChainedResponse(req);
            
            //the chained calls go in sequence, all results are aggregated into one result (sort of)
            for(int csx = 0; csx < req.requests().length; csx++)
            {
            	AppHelper.log("EXECUTING " + req.requests()[csx].key());
            	
            	req.requests()[csx].pushParameters(req.getParameters());
            	SimpleResponse _sresponse = new SimpleResponse(req.requests()[csx]);
            	
            	ParameterValidationResult vresult = req.requests()[csx].validate();            	

                if(vresult.valid())
                {
                	try{
                	
    	                String request_xml = buildSoapRequest(req.requests()[csx]);
    	
    	                
    	                AppHelper.log("\nDATA TO SEND\n-------------------------------\n" + AppHelper.getPrettyPrintXML(request_xml) + "\n-------------------------------\n");
    	                
    	                //create a connection to the remote server
    	                HttpURLConnection mvicon = (HttpURLConnection)AppHelper.i().getServiceConnection(req.requests()[csx].template().url());
    	                mvicon.setDoOutput(true);
    	                mvicon.setRequestMethod("POST");
    	
    	                //set all the headers required for this call
    	                for(TemplateHttpHeader hdr: req.requests()[csx].template().http_headers())
    	                {
    	                    mvicon.setRequestProperty(hdr.key(), hdr.value());
    	                }
    	
    	                //set the content length
    	                mvicon.setRequestProperty("Content-Length", String.valueOf(request_xml.getBytes().length));
    	
    	                //write out the request
    	                BufferedWriter data_out = new BufferedWriter(new OutputStreamWriter(new DataOutputStream(mvicon.getOutputStream()), "UTF-8"));
    	                data_out.write("\r\n");
    	                data_out.write(request_xml);
    	                data_out.write("\r\n");
    	                data_out.flush();
    	                data_out.close();
    	
    	                //read in the respons
    	
    	                String data_line;
    	                StringBuilder return_data = new StringBuilder();
    	
    	                BufferedReader data_in;
    	                if (mvicon.getResponseCode() == 500)//did we get an error? if so, set the reader to the error stream
    	                    data_in = new BufferedReader(new InputStreamReader(new DataInputStream(mvicon.getErrorStream()), "UTF-8"));
    	                else //no error?  Then set the reader to the standard stream
    	                    data_in = new BufferedReader(new InputStreamReader(new DataInputStream(mvicon.getInputStream()), "UTF-8"));
    	
    	                //read all the data from the stream
    	                while ((data_line = data_in.readLine()) != null) {
    	                        return_data.append(data_line);
    	                }
    	
    	                data_in.close();
    	
    	                //if there was an error, throw it using the data that came in from the error stream as the message
    	                if (mvicon.getResponseCode() == 500)
    	                    throw new Exception(return_data.toString());//the return data will have the error in it
    	
    	               
    	                //set some generic properties on the response that are only available on the connection before it's disconnected
    	                _sresponse.HTTP_RESP_CODE = mvicon.getResponseCode(); 
    	                _sresponse.HTTP_CONTENT_LENGTH = mvicon.getContentLength();
    	                _sresponse.HTTP_CONTENT_TYPE = mvicon.getContentType();
    	                _sresponse.HTTP_RESPONSE_MESSAGE = mvicon.getResponseMessage();
    	                mvicon.disconnect();
    	
    	                
    	                AppHelper.log("\nDATA RETURNED\n-------------------------------\n" + AppHelper.getPrettyPrintXML(return_data.toString()) + "\n-------------------------------\n");
    	                
    	                //now, process the response
    	                _sresponse.processResult(return_data.toString());
    	                
    	                _response.addResponse(_sresponse);
    	                req.forwardParameters(_sresponse);
    	                
                	}catch(Exception e)
                	{
                		
                		_response.setError(e);
                		_response.setErrorMessage(req.requests()[csx].template().failmsg() + "\nRETURNED MESSAGE : " + e.getMessage());
                		csx = req.requests().length + 1;//break the loop
                	}
                	
                	
                	
                	
                }else
                {
                	_response.setError(new Exception(vresult.message()));
            		_response.setErrorMessage(req.requests()[csx].template().failmsg());
            		csx =  req.requests().length + 1;//break the loop because there was a problem            		
                	
                }//end validation condition   
                
            }//end request loop
            
           
        }
        

        return _response;
    }
    
    /**
     * @param req
     * @return
     */
    private String buildSoapRequest(SimpleRequest req)
    {
        
        String raw_request = req.template().raw_request_body();
  
        for(SimpleTemplateRequestParameter rp:req.template().parameters())
        {
            
            if(req.parameters().containsKey(rp.name().toLowerCase()))
            {
            	while(raw_request.contains(rp.token()))
            	{
            		raw_request = raw_request.replace(rp.token(), req.parameters().get(rp.name().toLowerCase()));
            	}
            }else
            {
                raw_request = raw_request.replace(rp.token(), "");
            }
        }        
        
        return raw_request;
    }


}
